/**********
* File: CDGL_IDirect3DVertexShader9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DVertexShader9. 
					 This class is the concrete implementation of IDirect3DVertexShader9 interface. The IDirect3DVertexShader9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 18Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DVERTEXSHADER9_H__
#define __CDGL_IDIRECT3DVERTEXSHADER9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

#ifndef LIB_CHANGES
#include "OZone/IShader.h"
#else
#include "IShader.h"
#endif	// LIB_CHANGES

class CDGL_IDirect3DVertexShader9: public IDirect3DVertexShader9
{
	public:
	
		CDGL_IDirect3DVertexShader9(IDirect3DDevice9* in_pDevice);
		~CDGL_IDirect3DVertexShader9();
		
		 /*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DVertexShader9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT GetFunction( void*,UINT* pSizeOfData);
		
		// bala:
		// other funcs
		IShader		GetOZShader();
		void			SetShaderSource(const DWORD* pFunction);
		CDGL_IDirect3DVertexShader9(IDirect3DDevice9* in_pDevice, const DWORD* pFunction);
	
	private:
		
		//! Member Variables
		IDirect3DDevice9 *		m_pDevice;
		int						m_lRefCount;
		// bala:
		IShader					mShader;
};


#endif //__CDGL_IDIRECT3DVERTEXSHADER9_H__

